/* UART.H, include file for the UART.ASM, (c) 1996 Pawel Jalocha */

extern unsigned int far UartIntrCount;	/* counts interrupts generated by the UART */
extern unsigned int far UartRxErrCount;	/* counts errors on receive: framing and buffer overrun */

#define UartDivisor(BaudRate) (unsigned int)(115200L/BaudRate)
int far UartOpen(unsigned BaudDivisor, int Addr, int Irq); /* opens the UART communication */
void far UartClose(void); /* closes the UART communication, restores the interrupt vector */

void far UartStart(void);       /* resumes the communication (enable the UART interrupt) */
void far UartStop(void);	/* holds the communication (disable the UART interrupt) */

int far UartTxChar(char ch);	/* sends a single character (byte), returns non-zero if the Tx buffer is full */
int far UartTxStr(char *str);	/* sends a NULL terminated string, returns non-zero if the Tx buffer is full */
int far UartTxBlock(void *block, int len); /* send a block of data, returns non-zero if the block does not fit into the Tx buffer */
int far UartTxEmpty(void);	/* checks if all data is physically sent out */

int far UartRxChar(char *ch, int read);	/* receive a single character (byte), returns non-zero if the Rx buffer is empty */
int far UartRxReady(void);	/* returns how many bytes are ready and waiting in the Rx buffer */
void far UartRxFlush(void);	/* discards all data in the Rx buffer */
int far UartRxBlock(void *block, int len, int read); /* reads a block of data, returns non-zero if not enough data in the the Rx buffer */
int far UartRxSeekTerm(char term); /* seeks a terminator in the Rx buffer, returns the number of bytes one should read to get the terminator */
int far UartRxLine(char *line, int maxlen, char term, int read); /* reads a line using 'term' as the terminating character */

int far UartCTS(void);		/* read the state of the RS232 lines */
int far UartDCD(void);
int far UartDSR(void);
int far UartRI(void);

int far UartDTR(void);
int far UartRTS(void);

void far UartSetDTR(int level);	/* set the level of the DTR and RTS */
void far UartSetRTS(int level);

